<?php
session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';

if (!is_admin()) {
    redirect('/login.php');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - CarDealer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/assets/css/admin.css">
</head>
<body>
    <div class="admin-wrapper">
        <!-- Sidebar -->
        <nav id="sidebar" class="sidebar">
            <div class="sidebar-header">
                <h3><i class="fas fa-car-alt me-2"></i>CarDealer</h3>
            </div>

            <ul class="list-unstyled components">
                <li class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                    <a href="/admin/index.php">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                
                <li class="<?php echo in_array(basename($_SERVER['PHP_SELF']), ['manage_cars.php', 'add_car.php', 'edit_car.php']) ? 'active' : ''; ?>">
                    <a href="#carsSubmenu" data-bs-toggle="collapse" aria-expanded="false" class="dropdown-toggle">
                        <i class="fas fa-car"></i>
                        <span>Cars</span>
                    </a>
                    <ul class="collapse list-unstyled <?php echo in_array(basename($_SERVER['PHP_SELF']), ['manage_cars.php', 'add_car.php', 'edit_car.php']) ? 'show' : ''; ?>" id="carsSubmenu">
                        <li><a href="/admin/manage_cars.php">Manage Cars</a></li>
                        <li><a href="/admin/add_car.php">Add New Car</a></li>
                    </ul>
                </li>

                <li class="<?php echo in_array(basename($_SERVER['PHP_SELF']), ['manage_brands.php', 'manage_models.php']) ? 'active' : ''; ?>">
                    <a href="#catalogSubmenu" data-bs-toggle="collapse" aria-expanded="false" class="dropdown-toggle">
                        <i class="fas fa-tags"></i>
                        <span>Catalog</span>
                    </a>
                    <ul class="collapse list-unstyled <?php echo in_array(basename($_SERVER['PHP_SELF']), ['manage_brands.php', 'manage_models.php']) ? 'show' : ''; ?>" id="catalogSubmenu">
                        <li><a href="/admin/manage_brands.php">Brands</a></li>
                        <li><a href="/admin/manage_models.php">Models</a></li>
                    </ul>
                </li>

                <li class="<?php echo basename($_SERVER['PHP_SELF']) == 'manage_users.php' ? 'active' : ''; ?>">
                    <a href="/admin/manage_users.php">
                        <i class="fas fa-users"></i>
                        <span>Users</span>
                    </a>
                </li>

                <li class="<?php echo basename($_SERVER['PHP_SELF']) == 'test_drives.php' ? 'active' : ''; ?>">
                    <a href="/admin/test_drives.php">
                        <i class="fas fa-calendar-check"></i>
                        <span>Test Drives</span>
                    </a>
                </li>

                <li class="<?php echo basename($_SERVER['PHP_SELF']) == 'inquiries.php' ? 'active' : ''; ?>">
                    <a href="/admin/inquiries.php">
                        <i class="fas fa-envelope"></i>
                        <span>Inquiries</span>
                    </a>
                </li>

                <li class="<?php echo basename($_SERVER['PHP_SELF']) == 'manage_model_codes.php' ? 'active' : ''; ?>">
                    <a href="/admin/manage_model_codes.php">
                        <i class="fas fa-code"></i>
                        <span>Model Codes</span>
                    </a>
                </li>
            </ul>
        </nav>

        <!-- Page Content -->
        <div id="content">
            <!-- Top Navbar -->
            <nav class="navbar navbar-expand-lg navbar-light top-navbar">
                <div class="container-fluid">
                    <button type="button" id="sidebarCollapse" class="btn btn-link d-md-none">
                        <i class="fas fa-bars"></i>
                    </button>

                    <div class="ms-auto d-flex align-items-center">
                        <div class="dropdown">
                            <button class="btn btn-link dropdown-toggle text-dark" type="button" id="userDropdown" data-bs-toggle="dropdown">
                                <i class="fas fa-user-circle"></i>
                                <span class="ms-2">Admin</span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="/profile.php"><i class="fas fa-user me-2"></i>Profile</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="/logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>

            <div class="content-wrapper"> 